(function () {
    var app = angular.module('notifications', []);

    app.directive('notifications', function () {
        return {
            restrict: 'E',
            scope: {},
            templateUrl: 'templates/notifications.html',
            controller: function ($rootScope, $scope) {
                let ctrl = this;
                Helpers.RootScopeWatchAndDestroy($scope, 'settings.notifications', notifications => {
                    if(notifications == null) return;
                    ctrl.notifications = $rootScope.settings.notifications.filter(x => !x.closed);
                }, true);

                ctrl.clickNotification = notification => {

                    if(notification.target != null) {
                        $rootScope.setActiveView(notification.target.view, notification.target.tab);
                    }

                    notification.closed = true;
                };
            },
            controllerAs: 'ctrl'
        };
    });
})();